import math
from typing import Tuple
from dataclasses import dataclass


@dataclass
class GridDimensions2D:
    width: int
    height: int


def find_rectangle_dimensions(area: int) -> GridDimensions2D:
    """
    Find the length and breadth of a rectangle with the least perimeter for a given area.

    Args:
        area (int): The area of the rectangle.

    Returns:
        GridDimensions2D: contains the length and breadth of the rectangle.
    """
    length = int(math.sqrt(area))  # Starting with a square shape
    while area % length != 0:
        length -= 1

    breadth = area // length

    return GridDimensions2D(width=breadth, height=length)
