import ujson
import os


def dict_to_json(dictionary, filename):
    with open(filename, "w") as fp:
        ujson.dump(dictionary, fp, indent=4)


def load_json_as_dict(filename: str):
    assert os.path.exists(filename), f"Could not find json file: {filename}"
    try:
        with open(filename) as json_file:
            data = ujson.load(json_file)
    except ujson.decoder.JSONDecodeError:
        raise AssertionError(f"Error reading filename: {filename}")

    return data
