def get_tensor_size_string(tensor):
    # Get the size of the tensor in bytes
    size_in_bytes = tensor.element_size() * tensor.numel()

    # Determine the appropriate unit
    if size_in_bytes >= 2**30:  # Gigabytes (GB)
        size_str = f"{size_in_bytes / (2**30):.2f} GB"
    elif size_in_bytes >= 2**20:  # Megabytes (MB)
        size_str = f"{size_in_bytes / (2**20):.2f} MB"
    elif size_in_bytes >= 2**10:  # Kilobytes (KB)
        size_str = f"{size_in_bytes / (2**10):.2f} KB"
    else:  # Bytes (B)
        size_str = f"{size_in_bytes} bytes"

    return size_str
