import os

def get_filenames_in_a_folder(folder: str):
    """
    returns the list of paths to all the files in a given folder
    """

    if folder[-1] == "/":
        folder = folder[:-1]

    files = os.listdir(folder)
    files = [f"{folder}/" + x for x in files]
    return files


shell_commands_dir = "./slurm"
all_shell_scripts = get_filenames_in_a_folder(folder=shell_commands_dir)
for script in all_shell_scripts:
    command = f"sbatch {script}"
    print(command)
    os.system(command)