import os


def extract_run_name_and_checkpoint_info(gpt_checkpoint_filename: str):

    """
    example filename:

    /mindhive/nklab3/users/XXXX-1/repos/nesim/training/gpt_neo_125m/checkpoints/apply_nesim_every_n_steps_10_nesim_config_scale_0.06_shrink_factor_[9.0]_layer_names_index_10_and_11_checkpoint_every_n_steps_100_num_warmup_steps_7000_batch_size_32_context_length_1024/checkpoint-2700/pytorch_model.bin
    """
    list_of_levels = gpt_checkpoint_filename.split("/")
    run_name = list_of_levels[-3]
    checkpoint_info = list_of_levels[-2]
    return f"{run_name}_{checkpoint_info}"


def get_run_name(
    config_name,
    checkpoint_name,
):
    run_name = f"{checkpoint_name}_{config_name}"
    return run_name
