from nesim.losses.nesim_loss import (
    NesimConfig,
    NeighbourhoodCosineSimilarity,
    LaplacianPyramid,
    Ring1D,
    Ring,
)
import os
from nesim.utils.folder import make_folder_if_does_not_exist


config_folder = "./nesim_configs"

make_folder_if_does_not_exist(config_folder)

os.system(f"mkdir -p {config_folder}")
os.system(f"rm {config_folder}/*.json")

laplacian_scales = [1, 2, 3]
laplacian_shrink_factors = [2, 3]

for laplacian_scale in laplacian_scales:
    for laplacian_shrink_factor in laplacian_shrink_factors:

        nesim_config = NesimConfig(
            layer_wise_configs=[
                LaplacianPyramid(
                    layer_name="4",
                    scale=laplacian_scale,
                    shrink_factor=[laplacian_shrink_factor],
                )
            ]
        )

        nesim_config.save_json(
            filename=os.path.join(
                config_folder,
                f"laplacian_scale_{laplacian_scale}_shrink_factor_{laplacian_shrink_factor}.json",
            )
        )

print(f"saved configs at: {config_folder}")

#in case: AttributeError: 'NesimConfig' object has no attribute 'model_dump', use pip install pydantic --upgrade