# Nesim

Experimenting with Neighbourhood similarity losses to induce self-organization in neural network weights.

Example:

```python
import torchvision.models as models
from nesim.losses.nesim_loss import (
    NesimConfig, 
    NesimLoss, 
    NeighbourhoodCosineSimilarity, 
    LaplacianPyramid
)


model = models.resnet18(weights = None)
config = NesimConfig(
    layer_wise_configs = [
        ## scale = None -> just watch the layer's loss, do not backprop
        NeighbourhoodCosineSimilarity(layer_name = 'layer4.0.conv1', scale = None),
        NeighbourhoodCosineSimilarity(layer_name = 'layer3.1.conv2', scale = 0.1),
        LaplacianPyramid(layer_name = 'fc', scale = 0.1, shrink_factor = [2.]),
    ],
)

loss = NesimLoss(
    model = model,
    config = config,
    device = 'cpu'
)

print(loss) ## shows basic info about the objective
print(loss.compute(reduce_mean = True)) ## returns a single number as tensor for backward()
print(loss.compute(reduce_mean = False)) ## returns a dict with layer names as keys
```

Saving and loading configs

```python
## remember that config is an insta
config.save_json(filename = 'config.json')
loaded_config = NesimConfig.from_json(filename = 'config.json')
```

## Dev setup

```
python3 setup.py develop
```

## Running tests

```
pytest -vvx tests/
## to run all tests on cpu only, you can run the following
CUDA_VISIBLE_DEVICES="" pytest -vvx tests
```

Testing on multiple threads:

```
pytest -n 4 -vvx tests/
```