from nesim.losses.nesim_loss import (
    NesimConfig,
    NeighbourhoodCosineSimilarity,
    LaplacianPyramid,
)
from nesim.utils.json_stuff import load_json_as_dict
import os

config_folder = "./nesim_configs"
os.system(f"rm {config_folder}/*.json")

possible_shrink_factors = [[5.0]]

possible_loss_scales = [
    0.1,
    1,
    10,
    50,
    100,
    150,
    200,
]

posible_nesim_layers = load_json_as_dict("possible_nesim_layers.json")

num_configs = 0

for shrink_factor in possible_shrink_factors:
    for loss_scale in possible_loss_scales:
        for key, nesim_layer_names in posible_nesim_layers.items():
            layer_wise_configs = []

            for layer_name in nesim_layer_names:
                # scale is none for neighbourhood cossim because we just want to watch it
                layer_wise_configs.append(
                    NeighbourhoodCosineSimilarity(layer_name=layer_name, scale=None)
                )

                layer_wise_configs.append(
                    LaplacianPyramid(
                        layer_name=layer_name,
                        scale=loss_scale,
                        shrink_factor=shrink_factor,
                    )
                )

            nesim_config = NesimConfig(
                layer_wise_configs=layer_wise_configs,
            )

            if not isinstance(loss_scale, float) and not isinstance(loss_scale, int):
                loss_scale = loss_scale.get_name()
            filename = f"shrink_factor_{shrink_factor}_loss_scale_{loss_scale}_layers_{key}.json"

            nesim_config.save_json(filename=os.path.join(config_folder, filename))
            num_configs += 1

print(f"saved {num_configs} configs")
