import os
from nesim.utils.json_stuff import load_json_as_dict, dict_to_json

possible_model_names = [
    ## all_topo
    # "end_topo_scale_1.0_shrink_factor_3.0",
    # "end_topo_scale_5.0_shrink_factor_3.0",
    # "end_topo_scale_10.0_shrink_factor_3.0",
    # "end_topo_scale_50.0_shrink_factor_3.0",
    # ## end_topo
    "all_topo_scale_0.5_shrink_factor_3.0",
    "all_topo_scale_1_shrink_factor_3.0",
    "all_topo_scale_5_shrink_factor_3.0",
    "all_topo_scale_10.0_shrink_factor_3.0",
    "all_topo_scale_20.0_shrink_factor_3.0",
    "all_topo_scale_50.0_shrink_factor_3.0",
    ## baseline
    "baseline_scale_None_shrink_factor_3.0",
]

modes = [
    # {
    #     "model_prefix": "end_topo",
    #     "sparsify_layers": "end"
    # },
    {
        "model_prefix": "all_topo",
        "sparsify_layers": "all"
    },
    # {
    #     "model_prefix": "all_topo",
    #     "sparsify_layers": "all"
    # }
]

for mode in modes:
    loaded_results = {}
    for name in possible_model_names:
        if name.startswith(mode["model_prefix"]) or name.startswith("baseline"):
            layers = mode["sparsify_layers"]

            single_model_result_filename = os.path.join(
                "results",
                f"{name}_sparsify_{layers}.json"
            )
            print(f"mode: {mode} name: {name} Loading: {single_model_result_filename}")
            data =  load_json_as_dict(
                single_model_result_filename
            )
            loaded_results[name] = data
        else:
            pass
    # print(loaded_results.keys())
    filename = f'results_{mode["model_prefix"]}_sparsify_{mode["sparsify_layers"]}.json'
    dict_to_json(
        dictionary=loaded_results,
        filename=filename
    )
    print(f"Saved: {filename}")