import torch.nn as nn

"""
replacing layers by setattr with layername does not work for nn.Sequential
so in the original code the nn.Conv2d layers inside nn.Sequential are not replaced correctly, 
and if print elements in model.named_modules() and model.named_parameters(), 
there will be an extra module with the same name for each nn.Conv2d in nn.Sequential,
and the final model does not have the nn.Conv2d replaced
"""


def setattr_pytorch_model(model: nn.Module, name: str, item: nn.Module):
    """Replaces a named module with another module in pytorch
    workaround for setattr not working for nn.Sequential

    Args:
        model (nn.Module): the model, one of whose layers is to be replaced
        name (str): name of the layer to be replaced, generally found in model.named_parameters()
        item (nn.Module): new layer that would replace the existing layer
    """
    levels = name.split(".")
    if len(levels) > 1:
        mod_ = model
        for l_idx in range(len(levels) - 1):
            if levels[l_idx].isdigit():
                mod_ = mod_[eval(levels[l_idx])]
            else:
                mod_ = getattr(mod_, levels[l_idx])
        setattr(mod_, levels[-1], item)
    else:
        setattr(model, name, item)
    return model
