import pytest
import os
from nesim.configs import NeighbourhoodCosineSimilarity, LaplacianPyramid, NesimConfig

test_config_filename = "test_config.json"
scale_possible_values = [0.1, None]
layer_name_possibe_values = ["hello", "world"]
num_items_possible_values = [1, 5]


@pytest.mark.parametrize("scale", scale_possible_values)
@pytest.mark.parametrize("layer_name", layer_name_possibe_values)
@pytest.mark.parametrize("num_items", num_items_possible_values)
def test_config_json_save_and_load(scale, layer_name, num_items):

    layer_config = NeighbourhoodCosineSimilarity(layer_name=layer_name, scale=scale)

    combined = NesimConfig(
        layer_wise_configs=[layer_config for i in range(num_items)]
        + [
            LaplacianPyramid(layer_name=layer_name, scale=scale, shrink_factor=[1.0])
            for i in range(num_items)
        ],
    )

    combined.save_json(test_config_filename)
    combined2 = NesimConfig.from_json(test_config_filename)

    assert (
        combined == combined2
    ), "Expected config from json to be the same as the original one"
    os.system(f"rm {test_config_filename}")
