from nesim.eval.resnet import load_resnet18_checkpoint, load_resnet50_checkpoint
from nesim.eval.eshed import load_eshed_checkpoint
from helpers.load_images import load_images
from helpers.preprocess_image import preprocess
from helpers.load_brain_data import load_brain_data
from helpers.hook import get_intermediate_layer_activations

import torch
from sklearn.linear_model import LinearRegression
from sklearn.metrics import mean_squared_error
from einops import rearrange, reduce
import scipy
import numpy as np
import json
import os
from tqdm import tqdm

# device = "cuda" if torch.cuda.is_available() else "cpu"
device="cpu"
print(f"using {device}")
train_test_split_index = 800  # Should be under 1000

# all_tdann_layers = [
#     # 'base_model.conv1', 
#     'base_model.layer1.0.conv1', 
#     'base_model.layer1.0.conv2', 
#     'base_model.layer1.1.conv1', 
#     'base_model.layer1.1.conv2', 
#     'base_model.layer2.0.conv1', 
#     'base_model.layer2.0.conv2', 
#     'base_model.layer2.1.conv1', 
#     'base_model.layer2.1.conv2', 
#     'base_model.layer3.0.conv1', 
#     'base_model.layer3.0.conv2', 
#     'base_model.layer3.1.conv1', 
#     'base_model.layer3.1.conv2', 
#     'base_model.layer4.0.conv1', 
#     'base_model.layer4.0.conv2', 
#     'base_model.layer4.1.conv1', 
#     'base_model.layer4.1.conv2'
# ]

all_tdann_layers = [
    # "base_model.layer1.0",
    # "base_model.layer1.1",
    # "base_model.layer2.0",
    # "base_model.layer2.1",
    "base_model.layer3.0",
    "base_model.layer3.1",
    "base_model.layer4.0",
    "base_model.layer4.1",
]


layer_names = {
    "tdann": all_tdann_layers
}

# Helper function to evaluate models
def evaluate_model(model, layer_name, model_name, brain_data, preprocessed_images, eval_results, model_type, topo_mode):
    activations = get_intermediate_layer_activations(
        model=model,
        layer_name=layer_name,
        input_images=preprocessed_images.to(device, dtype=torch.float),
    )   

    activations = rearrange(activations, "b c h w -> b (c h w)")  # Flatten
    # raise AssertionError(activations.shape)
    activations = activations.cpu().numpy()
    X_train, X_test = activations[:train_test_split_index], activations[train_test_split_index:]
    y_train, y_test = brain_data[:train_test_split_index], brain_data[train_test_split_index:]

    # Train regression model
    regression_model = LinearRegression()
    # print(f"training regression model...  X_train {X_train.shape} y_train {y_train.shape}")
    regression_model.fit(X_train, y_train)
    y_pred = regression_model.predict(X_test)

    # Calculate metrics
    mse = mean_squared_error(y_test, y_pred)
    # raise AssertionError(y_pred.shape, y_test.shape)

    
    # pearson_r_individual = [scipy.stats.pearsonr(y_test[i, :], y_pred[i, :])[0] for i in range(y_test.shape[0])]
    pearson_r_individual = [scipy.stats.pearsonr(y_test[:, i], y_pred[:, i])[0] for i in range(y_test.shape[1])]

    mean_pearson_r = float(np.mean(pearson_r_individual))

    print(model_type, model_name, layer_name)
    eval_results[model_type][model_name][layer_name]["mse"] = float(mse)
    eval_results[model_type][model_name][layer_name]["mean_pearson_r"] = mean_pearson_r
    eval_results[model_type][model_name][layer_name]["pearson_r_individual"] = pearson_r_individual

    print(f"Val set mse: {mse}, mean_pearson_r: {mean_pearson_r}")

# Load data (this is common for all models)
def load_data(subj, roi):
    brain_data = load_brain_data(
        dataset_name="NSD1000",
        subject=subj,
        roi=roi,
        dataset_root="./",
        averaging=False,
    )
    print("loaded brain data ")
    brain_data = reduce(brain_data, "n_stim trials voxels -> n_stim voxels", "mean")  # Mean of 3 trials

    images = load_images(
        dataset_name="NSD1000",
        dataset_root="./",
    )
    print("loaded images ")
    preprocessed_images = preprocess(
        images=images, mean=[0.485, 0.456, 0.406], std=[0.229, 0.224, 0.225]
    )
    print("preprocessed images ")

    return brain_data.cpu().numpy(), preprocessed_images

def run_experiment(subj, roi):

    # tdann_directory = "/home/XXXX-5/repos/nesim/training/brainmodels/eshed_checkpoints/"
    tdann_directory = "/home/XXXX-5/repos/nesim/training/brainmodels/eshed_checkpoints/"

    tdann_file_nicknames = [
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_lwx5_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_lwx2_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_resnet18_lw0_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_lwx10_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_lw01_checkpoints/model_final_checkpoint_phase199.torch',
    # 'supervised_spatial_resnet18_swappedon_SineGrating2019_lwx100_checkpoints/model_final_checkpoint_phase199.torch',

    # "alex_tdann_res18_simclr_checkpoint.torch",
    "alex_tdann_res18_simclr_spatial_sinegrating.torch"
]

    tdann_checkpoint_paths = [tdann_directory+i for i in tdann_file_nicknames]
    
    eval_results = {
    "tdann": {
        name: {layer: {} for layer in layer_names["tdann"]}
        for name in tdann_file_nicknames
    },
}
    import pprint
    # pprint.pprint(eval_results)
    # raise AssertionError()

    brain_data, preprocessed_images = load_data(subj, roi)

    total_runs_tdann = len(tdann_checkpoint_paths) * len(all_tdann_layers)
    runs_left_tdann = total_runs_tdann

    for tdann_checkpoint_path, tdann_nickname in zip(tdann_checkpoint_paths[:], tdann_file_nicknames[:]):
        for layer_name in all_tdann_layers[:]:
            # print(layer_name)
            topo_mode = "tdann"
            model = load_eshed_checkpoint(tdann_checkpoint_path).to(device)
            evaluate_model(model, layer_name, tdann_nickname, brain_data, preprocessed_images, eval_results, "tdann", topo_mode)
            # pprint.pprint(eval_results["tdann"])
            runs_left_tdann -= 1
            print(f"Runs left: {runs_left_tdann} total {total_runs_tdann}")

    # Save results
    with open(f"./eval_jsons_3/tdann_eval_subj0{subj}_{roi}_alex_checkpoints.json", "w") as f:
        # print(f"SAVED: tdann_eval_subj0{subj}_{roi}.json")
        json.dump(eval_results, f, indent=4)

import argparse
parser = argparse.ArgumentParser(description="Run experiment with voxels from ROI.")
parser.add_argument('--roi', type=str, required=True, help='Region of interest (e.g., "ppa")')
args = parser.parse_args()
run_experiment(subj=1, roi=args.roi)
