import subprocess

# List of all ROIs
# rois = ["v1v", "v1d", "v2v", "v2d", "v3v", "v3d", "hv4"]
rois = ["v1v", "v1d", "v2v", "v2d", "v3v", "v3d", "hv4", "ffa", "eba", "ppa", "vwfa", "vtc"]


# Function to run a command
def run_command(command):
    print(f"Running: {command}")
    subprocess.run(command, shell=True, check=True)

# Loop through each ROI and run both TDANN and ResNet-18 evaluations
for roi in rois:
    try:
        # Run TDANN evaluation
        tdann_command = f"python3 -W ignore fast_tdann_eval.py --roi {roi}"
        run_command(tdann_command)
        
        # Run ResNet-18 evaluation
        resnet_command = f"python3 -W ignore fast_resnet18_eval.py --roi {roi}"
        run_command(resnet_command)
        
        print(f"Finished evaluations for ROI: {roi}")
    except subprocess.CalledProcessError as e:
        print(f"An error occurred while processing ROI: {roi}")
        print(e)

print("All evaluations completed!")
