import os

slurm_commands_folder = "./slurm"
slurm_prefix = """#!/bin/sh
#SBATCH --ntasks-per-node=32
#SBATCH --job-name=gpt-dataset-json-saving
#SBATCH -t 48:00:0
#SBATCH --mem=64G

source /mindhive/nklab3/users/XXXX-1/conda_stuff/bin/activate
conda activate neuro
"""

all_commands = [
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 0 --end-idx 2000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 2000000 --end-idx 4000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 4000000 --end-idx 6000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 6000000 --end-idx 8000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 8000000 --end-idx 10000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 10000000 --end-idx 12000000",
    "python3 build_faster_dataset.py --output-folder faster_dataset_json_files --start-idx 12000000 --end-idx 15082911",
]

slurm_shell_files = []
for command_index, command in enumerate(all_commands):
    shell_commands = slurm_prefix + command
    filename = os.path.join(slurm_commands_folder, f"{command_index}.sh")
    with open(filename, "w") as file:
        file.write(shell_commands)
    slurm_shell_files.append(filename)

print(f"Saved {len(slurm_shell_files)} shell files")
