from typing import Union


def get_run_name(
    nesim_config: str,
    cross_layer_correlation_loss_config: str,
    pretrained: bool,
    nesim_apply_after_n_steps: int,
    bimt_scale: Union[float, None],
    apply_sorted_weights_init_filename: Union[str, None],
):
    if cross_layer_correlation_loss_config is not None:
        cross_layer_correlation_loss_config = (
            cross_layer_correlation_loss_config.replace(".json", "").split("/")[-1]
        )
    else:
        cross_layer_correlation_loss_config = ""
    return f'power_spectrum_{nesim_config.replace(".json", "").split("/")[-1]}_{cross_layer_correlation_loss_config}_bimt_scale_{bimt_scale}_from_pretrained_{pretrained}_apply_every_{nesim_apply_after_n_steps}_steps_apply_sorted_weights_init_filename_{apply_sorted_weights_init_filename}'
