from gratings import generate_stripes
import os
from tqdm import tqdm

stripe_width = 10  # Width of each stripe
num_stripes = 17  # Number of evenly spaced stripes

size = 224
possible_angles = [i for i in range(0, 360, 10)]

stripes_folder = "./stripes/"
os.system(f"rm {stripes_folder}*.jpg")

for orientation_angle in tqdm(possible_angles):
    image_filename = os.path.join(stripes_folder, f"{orientation_angle}.jpg")
    stripe_image = generate_stripes(
        size,
        stripe_width=stripe_width,
        num_stripes=num_stripes,
        orientation_angle=orientation_angle,
    )
    stripe_image.save(image_filename)

print("Dataset generation complete!")
