import torch.nn as nn
from functools import reduce


def get_model_layer_by_name(model: nn.Module, layer_name: str):
    """Retrieve a module nested in another by its access string.

    Works even when there is a Sequential in the module.

    Args:
        module (Union[TensorType, nn.Module]): module whose submodule you want to access
        name (str): the string representation of the submodule. Like `"module.something.this_thing"`

    Returns:
        object: module that you wanted to extract
    """
    if layer_name != "":
        names = layer_name.split(sep=".")
    else:
        return model
    return reduce(getattr, names, model)