import os
import argparse

# Create an ArgumentParser object
parser = argparse.ArgumentParser(description="Process a string input.")

# Add an argument for a string input
parser.add_argument('--train-path', type=str, help='train path', required = True)
parser.add_argument('--val-path', type=str, help='val path', required = True)
parser.add_argument('--output-folder', type = str, help = 'save folder', required = True)

# Parse the command-line arguments
args = parser.parse_args()

assert args.train_path.endswith(".tar")
assert args.val_path.endswith(".tar")

assert os.path.exists(args.train_path)
assert os.path.exists(args.val_path)

def get_tar_command(filename: str, extract_to: str):
    return f"tar -xvf {filename} -C {extract_to}"

train_extract_path = os.path.join(
        args.output_folder,
        "train"
    )

# os.system(f"mkdir -p {train_extract_path}")
train_tar_command = get_tar_command(
    filename=args.train_path,
    extract_to=train_extract_path
)

val_extract_path = os.path.join(
        args.output_folder,
        "val"
    )
# os.system(f"mkdir -p {val_extract_path}")

val_tar_command = get_tar_command(
    filename=args.val_path,
    extract_to=val_extract_path
)

# os.system(train_tar_command)
# os.system(val_tar_command)

# os.system(
#     f"sh setup_imagenet.sh --output-folder {args.output_folder}"
# )

final_save_dir =os.path.abspath(
        os.path.join(
        args.output_folder,
        "ffcv"
    )
)
os.system(f"mkdir -p {final_save_dir}")

final_command = f"""# Required environmental variables for the script:
export IMAGENET_DIR={os.path.abspath(args.output_folder)}
export WRITE_DIR={final_save_dir}

# Starting in the root of the Git repo:

# Serialize images with:
# - 500px side length maximum
# - 50% JPEG encoded
# - quality=90 JPEGs
./write_imagenet.sh 500 0.50 90
"""
os.system(final_command)

train_ffvc_path = os.path.exists(
    os.path.join(final_save_dir),
    "train_500_0.50_90.ffcv"
)
val_ffcv_path = os.path.exists(
    os.path.join(final_save_dir),
    "val_500_0.50_90.ffcv"
)

assert os.path.exists(train_ffvc_path)
assert os.path.exists(val_ffcv_path)
print(f"train dataset:")
print(train_ffvc_path)
print(f"\n\n val dataset path:")
print(val_ffcv_path)