import os
import numpy as np
import torch

import torch
import scipy.io

def save_tensor_as_mat(tensor, filename, var_name='tensor'):
    """
    Save a PyTorch tensor as a .mat file.
    
    Args:
        tensor (torch.Tensor): The PyTorch tensor to save.
        filename (str): The name of the .mat file to save to.
        var_name (str): The variable name to use inside the .mat file. Default is 'tensor'.
    """
    # Convert the tensor to a numpy array
    numpy_array = tensor.cpu().numpy()
    
    # Save the numpy array to a .mat file
    scipy.io.savemat(filename, {var_name: numpy_array})

names = [
    "untrained",
    "baseline",
    "topo_1",
    "topo_5",
    "topo_10",
    "topo_50",
]

arrays = []

for name in names:
    arrays.append(
        torch.tensor(np.load(os.path.join("results", f"{name}.npy"))).unsqueeze(0)
    )

arrays = torch.cat(arrays, dim = 0)

## 6 models, 12 layers, 5 random subsets of size 104857
print(arrays.shape)

save_tensor_as_mat(tensor = arrays, var_name="tensor", filename = "send_to_ratan.mat")