import matplotlib.pyplot as plt

def plot_category_area(data, filename):
    # Extract categories and their areas
    categories = data["topo_50"]
    
    # Initialize plot
    fig = plt.figure(figsize=(10, 6))
    
    # Plot area for each category
    for category, values in categories.items():
        layers = [item['layer_name'] for item in values]
        areas = [item['area'] for item in values]
        
        # Plot
        plt.plot(layers, areas, label=category, marker='o')
    
    # Customize plot
    plt.xlabel("Layer")
    plt.ylabel("Area")
    plt.title("Area by Layer for Each Category")
    plt.xticks(rotation=90)
    plt.legend()
    plt.grid(True)
    
    # Show plot
    plt.tight_layout()
    fig.savefig(filename)
# Example usage
from nesim.utils.json_stuff import load_json_as_dict
data = load_json_as_dict(
    filename = "results_category_areas.json"
)

plot_category_area(data, filename = "area.png")
