import libtmux

def launch_job_in_tmux(
    command: str,
    session_name: str,
) -> None:
    server = libtmux.Server()
    session = server.new_session(session_name=session_name, kill_session=True, attach=False)
    window = session.new_window(attach=True, window_name=session_name)
    pane1 = window.active_pane

    pane1.send_keys(command)
    print(f"Started job in tmux: {session_name}")