import time


def wall_clock_timer():
    start_time = time.time()

    yield start_time

    while True:
        yield time.time() - start_time


if __name__ == "__main__":
    timer = wall_clock_timer()
    t0 = next(timer)  # Initialize the timer

    # Simulate some work
    time.sleep(2)

    time_elapsed = next(timer)
    time_elapsed_mins = time_elapsed / 60
    print(f"Elapsed time: {time_elapsed_mins:.3} minutes")
