# Disentangled Fairness



## <span id="Installation">Installation</span>

Our development environment is `python 3.9 & pytorch 1.11.0+cu113`.

1. Create your conda environment if needed.

```bash
conda create -n disfair python==3.9 -y
```

2. Enter your conda environment.

```bash
conda activate disfair
```

3. Install PyTorch.

```bash
pip install torch==1.11.0+cu113 torchvision==0.12.0+cu113 --extra-index-url https://download.pytorch.org/whl/cu113
```

or you can refer to [PyTorch](https://pytorch.org/) to install newer or older versions. We strongly recommend you
use `pytorch >= 1.11.0` for its less GPU memory consumption.

4. Install the necessary dependencies.

```bash
pip install -r requirements.txt
```

## <span id="getting_started">Getting Started</span>

For a quick experience, you can directly run the following commands:

**Training**

```bash
CUDA_VISIBLE_DEVICES=0 \
python main.py \
  --config configs/config_celeba.py \
  --data_root ./data \
  --dataset celeba \
  --model resnet50 \
  --main_attr Attractive \
  --output_dir ./runs/attractive/resnet50_celeba \
  --note train_resnet50_attractive
```

The `CelebA` dataset will be downloaded to `./data/celeba`. During the training, the config file, checkpoints, logs and other outputs will be stored in
`./runs/__tmp__`.

**Evaluation on Statical Fairness Metrics**

```bash
CUDA_VISIBLE_DEVICES=0 \
python main.py \
  --config configs/config_celeba.py \
  --data_root ./data \
  --dataset celeba \
  --model resnet50 \
  --evaluator fairness \ 
  --main_attr Attractive \
  --sub_attrs 'Bald' 'Eyeglasses' 'Mouth_Slightly_Open' 'No_Beard' 'Pale_Skin' \ 
  --resume ./runs/attractive/resnet50_celeba/checkpoint0029.pth \
  --eval
```
Here we select the `Attractive` attribution as the task attribution by default, and `Bald`, `Eyeglasses`, `Mouth_Slightly_Open`, `No_Beard`, `Pale_Skin` as the sensitive attributions. By following this step you can get the fairness metric results based on the result statistics, such as `DP`, `EOpp`, `EOdd`, `AOdd`, etc

**Attractions Disentanglement**

```bash
CUDA_VISIBLE_DEVICES=0 \
python attr_disentangle.py \
  --dataset celeba \
  --seed 1 \
  --lr 1e-4 \
  --beta 10 \
  --beta1 0.9 \
  --beta2 0.999 \
  --objective H \
  --model H \
  --batch_size 64 \
  --max_iter 1.5e6 \
  --z_dim 10 \
  --viz_name celeba_H_beta10_z10
```
We choose to use beta-VAE as the tool for the decoupling of image sensitive attributes, and by setting the z_dim value, we can set the number of final decoupled sensitive attribute combinations, and obtain the mean and variance of its Gaussian distribution fitting    

**Evaluation on Disentangled Fairness**

```bash
CUDA_VISIBLE_DEVICES=0 \
python dynamic_pert.py \
  --model resnet50 \
  --z_dim 10 \
  --batch_size 10
```
Finally, the dynamic perturbation method is used to evaluate the fairness state of the visual classification model in the disentangled attributes. The new fairness metrics include `Tolerance`, `Deviation`, and `Coupling`