from .default import DefaultEvaluator
from .fairness import FairnessEvaluator


def build_evaluator(args):
    evaluator_name = args.evaluator.lower()

    if evaluator_name in ['default']:
        metrics = ['acc', 'recall', 'precision', 'f1']
        return DefaultEvaluator(metrics)
    elif evaluator_name in ['fairness']:
        fair_metrics = ['acc', 'dp', 'eopp', 'eodd', 'aod']
        return FairnessEvaluator(fair_metrics)

    raise ValueError(f"Evaluator '{evaluator_name}' is not found.")
