import sys
import os
import datetime

def get_args(sys_argv):
    arg_ = 'python '
    note_ = ''
    for i, arg in enumerate(sys_argv):
        if 'note' in arg:
            note_ = sys_argv[i + 1]
            i = i + 1
        else:
            arg_ = arg_ + arg + ' '
    if sys_argv[0][0] == '/':
        note_ = 'debug_' + sys_argv[0].rsplit("/", maxsplit=1)[-1]
    for j in range(24 - len(note_)):
        note_ = note_ + ' ' 
    return arg_, note_

def init_file(log_file):
    if not os.path.isfile(log_file):
        with open(log_file, 'w') as file:
            file.write('----------------------------------------------------------------------------------------\n')
            file.write('| Start Time           | Note                     | Arguments                          |\n')
            file.write('----------------------------------------------------------------------------------------\n')
            file.write('\n')

def update_log(log_file, start_time, note_, arg_):
    existing_content = []
    with open(log_file, 'r') as file:
        existing_content = file.readlines()
    existing_content.insert(3, f'| {start_time}* | {note_} | {arg_} |\n')
    if not existing_content[4][2:12] == str(start_time)[0:10]:
        existing_content.insert(4, '----------------------------------------------------------------------------------------\n')
    with open(log_file, 'w') as file:
        file.writelines(existing_content)
    print(f'Experiment log saved to {log_file} successfully.')

def check_finished(log_file):
    existing_content = []
    with open(log_file, 'r') as file:
        existing_content = file.readlines()
    existing_content[3] = existing_content[3].replace('*', ' ')
    with open(log_file, 'w') as file:
        file.writelines(existing_content)

def record_log(log_file = 'exp_log.txt', sys_argv = None):
    start_time = datetime.datetime.now().replace(microsecond=0) + datetime.timedelta(hours=8)
    init_file(log_file)
    arg_, note_ = get_args(sys_argv)
    update_log(log_file, start_time, note_, arg_)
