import numpy as np
from mani_skill.utils.geometry import rotation_conversions

# Task Plan Generation
plan_list = [
    "move to object",  # Move the robot to the peg
    "grasp object",  # Grasp the peg
    "rotate peg",  # Rotate the peg to upright position
    "move to goal",  # Move the peg to the goal position on the table
]

# Determination Function
def determination_function(self):
    # Extract the necessary information from the environment
    tcp_to_obj = np.linalg.norm(self.agent.tcp_pose.p.cpu().numpy().squeeze() - self.peg.pose.p.cpu().numpy().squeeze())
    obj_to_target = np.linalg.norm(self.peg.pose.p.cpu().numpy().squeeze() - [0, 0, 0.12])
    q = self.peg.pose.q
    qmat = rotation_conversions.quaternion_to_matrix(q)
    euler = rotation_conversions.matrix_to_euler_angles(qmat, "XYZ").cpu().numpy().squeeze()
    if tcp_to_obj > 0.025:
        return 0  # "move to object"
    elif self.agent.is_grasping(self.peg).cpu().numpy().squeeze() is False:
        return 1  # "grasp object"
    elif np.abs(np.abs(euler[2]) - np.pi / 2) > 0.08:
        return 2  # "rotate peg"
    elif np.abs(self.peg.position[2] - self.goal_pos[2]) > 0.02:
        return 3  # "move to goal"
    else:
        return -1  # Task complete

# Progress Function
def progress_function(self):
    subprogress = 0.0
    main_progress = 0.0
    current_subtask = determination_function(self)

    if current_subtask == 0:  # "move to object"
        subprogress = np.linalg.norm(self.agent.tcp_pose.p.cpu().numpy().squeeze() - self.peg.pose.p.cpu().numpy().squeeze()) / np.linalg.norm(
            self.robot.tcp_pos - np.array([0.0, 0.0, 0.0]))
        main_progress = current_subtask + subprogress

    elif current_subtask == 1:  # "grasp object"
        subprogress = self.agent.is_grasping(self.peg).cpu().numpy().squeeze()
        main_progress = current_subtask + subprogress

    elif current_subtask == 2:  # "rotate peg"
        subprogress = np.abs(np.abs(self.peg.euler[2]) - np.pi / 2) / (np.pi / 2)
        main_progress = current_subtask + subprogress

    elif current_subtask == 3:  # "move to goal"
        subprogress = np.abs(self.peg.position[2] - self.goal_pos[2]) / 0.02
        main_progress = current_subtask + subprogress

    return main_progress, current_subtask

