import numpy as np

# Plan the task into subtasks
def generate_plan_list():
    # Task decomposition: [verb + noun]
    plan_list = [
        'move to object',  # Subtask 1: Move to object
        'move to goal',    # Subtask 2: Move to goal
        'task complete'    # Task completion
    ]
    return plan_list

# Determining the current subtask based on environment information
def determination_function(self):
    normalize_dist = 0.2
    tcp_to_cube_thresh = 0.025
    cube_to_goal_thresh = 0.1

    tcp_pose = self.agent.tcp_pose.p.cpu().numpy().squeeze()
    cube_pos = self.obj.pose.p.cpu().numpy().squeeze()
    goal_pos = self.goal_region.pose.p.cpu().numpy().squeeze()

    tcp_to_cube_dist = np.linalg.norm(tcp_pose - cube_pos)
    cube_to_goal_dist = np.linalg.norm(cube_pos[:2] - goal_pos[:2])

    # Subtask 1: 'move to object'
    if tcp_to_cube_dist > tcp_to_cube_thresh:
        return 0  # Still moving towards the object

    # Subtask 2: 'move to goal'
    else:
        return 1  # Moving towards the goal

# Progress computation for each subtask
def progress_function(self):
    plan_list = generate_plan_list()
    subtask_idx = determination_function(self)

    # Initialize variables
    main_progress = 0.0  # Overall task progress

    # Subtask 1: 'move to object'
    if subtask_idx == 0:
        tcp_pose = self.agent.tcp_pose.p.cpu().numpy().squeeze()
        cube_pos = self.obj.pose.p.cpu().numpy().squeeze()
        tcp_to_cube_dist = np.linalg.norm(tcp_pose - cube_pos)
        subprogress = 1 - tcp_to_cube_dist / 0.2  # Normalize progress
        main_progress = subtask_idx + subprogress

    # Subtask 2: 'move to goal'
    elif subtask_idx == 1:
        cube_pos = self.obj.pose.p.cpu().numpy().squeeze()
        goal_pos = self.goal_region.pose.p.cpu().numpy().squeeze()
        cube_to_goal_dist = np.linalg.norm(cube_pos[:2] - goal_pos[:2])
        subprogress = 1 - cube_to_goal_dist / 0.2  # Normalize progress
        main_progress = subtask_idx + subprogress

    # Subtask 3: 'task complete'
    else:
        main_progress = 1.0  # Task is complete

    # Return the overall progress and current subtask index
    return main_progress, subtask_idx

