import numpy as np

# Plan the task into subtasks
def generate_plan_list():
    # Task decomposition: [verb + noun]
    plan_list = [
        'move to object',
        'move to goal',
        'task complete'
    ]
    return plan_list

# Determining the current subtask based on environment information
def determination_function(self, s):
    # Decompose the task completion into conditions for each subtask

    # Subtask 1: 'move to object'
    if np.linalg.norm(s[:3]-[0, 0, 0.045] - s[4:7]) > 0.02:
        return 0  # Still moving towards the object

    # Subtask 2: 'move to goal'
    elif np.linalg.norm(s[4:7] - s[36:39]) > 0.05:
        return 1  # Still moving towards the goal

    # Subtask 3: 'task complete'
    else:
        return 2  # Task is completed

# Progress computation for each subtask
def progress_function(self, s):
    plan_list = generate_plan_list()
    subtask_idx = determination_function(self, s)

    # Initialize variables
    main_progress = 0.0  # Overall task progress
    subprogress = 0.0  # Progress of the current subtask

    # Subtask 1: 'move to object'
    if subtask_idx == 0:
        # Progress of moving towards the object
        initial_distance = np.linalg.norm(self.env.hand_init_pos-[0, 0, 0.045] - self.env.obj_init_pos)
        current_distance = np.linalg.norm(s[:3]-[0, 0, 0.045] - s[4:7])
        subprogress = 1 - (current_distance / initial_distance)
        main_progress = subtask_idx + subprogress  # Task progress is the sum of subtasks

    # Subtask 3: 'move to goal'
    elif subtask_idx == 1:
        # Progress of moving towards the goal position
        initial_distance_to_goal = np.linalg.norm(self.env.obj_init_pos - s[36:39])
        current_distance_to_goal = np.linalg.norm(s[4:7] - s[36:39])
        subprogress = 1 - (current_distance_to_goal / initial_distance_to_goal)
        main_progress = subtask_idx + subprogress

    # Subtask 4: 'release object'
    elif subtask_idx == 2:
        # Task is complete, no further progress is needed
        subprogress = 1.0
        main_progress = 1.0

    return main_progress, subtask_idx