#!/bin/bash

conda create --name paired python=3.8
conda activate paired
pip install -r requirements.txt

git clone https://github.com/openai/baselines.git
cd baselines
pip install -e .
cd ..

# Python and most build deps
sudo apt-get install -y build-essential autoconf libtool pkg-config \
  python3-dev python3-pip python3-numpy git flex bison libbz2-dev

# recent cmake version
wget -O - https://apt.kitware.com/keys/kitware-archive-latest.asc 2>/dev/null | sudo apt-key add -
sudo apt-add-repository 'deb https://apt.kitware.com/ubuntu/ bionic main'
sudo apt-get update && sudo apt-get --allow-unauthenticated install -y \
    cmake \
    kitware-archive-keyring

cd ~
git clone https://github.com/facebookresearch/minihack.git
cd minihack
pip install -e .
cd ..