\# Install dependencies

pip install -r requirements.txt



\# Prepare your dataset directory

\# DATA\_ROOT should contain your CSV files and the 'images' subfolder.

\# E.g., /path/to/dataset/

\#         |---- images/

\#         |---- pretrain.csv      (Path to ALL images)

\#         |---- train\_set.csv     (Labeled train data)

\#         |---- val\_set.csv       (Labeled validation data)

\#         |---- unlabeled\_set.csv (Unlabeled train data)



\# Stage 1: MAE Pre-training

\# First, pre-train the ViT encoder.

\# 1. Edit pretrain\_mae.py: Set the path to your pretrain.csv file inside the script.

\# 2. Run training:

python pretrain\_mae.py

\# This saves the encoder weights (e.g., mae\_vit\_tiny\_encoder\_epoch\_200.pth).



\# Stage 2: Fine-tuning

\# Now, fine-tune the main KAN-Semi model.

\# 1. Edit meantteacher.py: Update the ViT\_PRETRAINED\_PATH variable to point to the weights saved in Stage 1.

\# 2. Run training:

python meantteacher.py \\

&nbsp;   --root\_dataset /path/to/dataset \\

&nbsp;   --save\_dir ./checkpoints \\

&nbsp;   --labeled\_batch\_size 12 \\

&nbsp;   --unlabeled\_batch\_size 12

\# The best model (best\_model.pth) will be saved in the --save\_dir.

