import json
import numpy as np
from numpy import array



def get_bank_data(fname, test=True):
    # Opening JSON file
    with open("data/{}.json".format(fname)) as json_file:
        data = json.load(json_file)
    if test:
        return array(data["Xtest"]), array(data["Ytest"])
    else:
        return array(data["Xtrain"]), array(data["Ytrain"])


for f in ["avila",
    "bank",
    "bean",
    "bidding",
    "eeg",
    "fault",
    "htru",
    "magic",
    "occupancy",
    "page",
    "raisin",
    "rice",
    "room",
    "segment",
    "skin",
    "wilt",]:
    X, Y = get_bank_data(f)
    x_y = np.hstack((X, Y.reshape(-1, 1)))
    np.savetxt("data/{}_test.txt".format(f), x_y, delimiter=",")