# Robust Algorithmic Recourse Design Under Model Shifts


## 1. Install requirements
```
pip install -r requirements.txt
```

## 2. Experiments
### Baseline recourse generating algorithms: 
Recourse generation for AR: /AR/
Recourse generation for CF: /CF/
Recourse generation for MINT: /MINT/

### Robust recourse generating algorithms:
Recourse generation for ROAR: /ROAR/
Recourse generation for ARAR: /ARAR/
Recourse generation for PROBE: /PROBE/
Recourse generation for DiRRAc: /DiRRAc/

### Generate recourse and evaluate on 3 different real-world datasets:
```
python train_real_data.py --mode linear --num_samples <number of samples to evaluate>
```

### Generate recourse for non-linear model and evaluate on 3 different real-world datasets:
```
python train_real_data.py --mode non --num_samples <number of samples to evaluate>
```

## 3. Other
`utils/`: basic R functions for generating the bounds
The following R packages are required to be installed: [grf](https://grf-labs.github.io/grf/), [tidyverse](https://www.tidyverse.org/).


