# Adversarial Robustness of LoRA - CV

This folder contains the code to run the Computer Vision related Evaluation
in our paper: "Theoretically Understanding the Hidden Adversarial Price of Low-Rank Adaptation" - which is currently under review in ICLR.

## Environment Setup
All the experiments have been performed using Python and the code is self-contained. The only requirements are related to PyTorch and Torch-Vision for the datasets.

- Note that for the CIFAR dataset family, the code directly downloaded the needed files.

## Reproducing the results:
To reproduce the results of the Head-Only finetuning strategy reported in our results, you should use the following command:

- For the CIFAR-10:

```python
python code_vit_complete.py --dataset cifar10
```

- For the CIFAR-100:
```python
python code_vit_complete.py --dataset cifar100
```

To produce the results on the LoRA finetuning strategy, the user should run:
- For the CIFAR-10:
```python
python code_lora_complete.py --dataset cifar10
```

- For the CIFAR-100:
```python
python code_lora_complete.py --dataset cifar100
```

Note that the code will run the PGD and FGSM for the required epsilon values that are considered in the paper. The results will be saved as a CSV file in a "Results" folder (that will be directly created if non-existent).

---

For any additional information, please refer to our paper.
