# Adversarial Robustness of LoRA - NLP

This folder contains the supplementary material for the NLP part of our paper on adversarial robustness of LoRA. To reproduce the experiments, we can follow the sections below.

## Environment Setup
We assume the presence of [pyenv](https://github.com/pyenv/pyenv) for Python version management, and we set Python 3.11.0. See [here](https://github.com/pyenv/pyenv) for the installation guide of pyenv.

We also assume the existence of at least one NVIDIA GPU in the compute unit used to reproduce the experiments. On the presence of multiple GPUs, our script can run independent experiments (e.g., same model, but different datasets) in parallel by overriding "GPUS ?= 0,1,2,3" (four GPUs will be used) in the Makefile to have a shorter waiting time for a collection of experiments to finish. For the NLP part of the experiment, we use Nvidia GPUs with 24 GB of VRAM. 

After installing pyenv, we can use the following command to install Python 3.11.0
```bash
pyenv install 3.11.0
```

After installing Python 3.11.0 on the compute machine, we can create the virtual environment and install the dependencies for NLP training, TextFooler attack, and A2T attack by calling the following target in Makefile:
```bash
make setup_all
```

The command will create three virtual environments under the folder ``envs/``. These virtual environments will be used later for the experiments.
```bash
tree envs -L 1
envs
├── a2t
├── nlp_training
└── textfooler
```

We use [huggingface](https://huggingface.co/) to get the pretrained models in NLP. For certain models, e.g., [Mistral-7B](https://huggingface.co/mistralai/Mistral-7B-v0.1), we need to create a HuggingFace account and explicitly ask for a grant of access to the model weights. After that, we can add the hf_token of our account in ``conf/config.yaml``.


## Launching Fine-tuning Experiments

We can use the following target to launch experiments for finetuning with head-only or LoRA experiments.
```bash
make ft_parallel
```

One can override ``PARALLEL_STRATEGIES``, ``PARALLEL_DATASETS``, ``PARALLEL_MODELS``, etc., to control what the experiments should cover.

After launching the experiments, the experiment results will be saved in the ``SEARCH_ROOT`` folder, e.g., "data_files/nlp_training". We save a single copy (for LoRA, we merge the LoRA weight with the weights of the pretrained model) of the model checkpoint for each experiment we run, which will later be used to evaluate the adversarial robustness of checkpoints trained by different models.


## Launching Adversarial Attacks
To launch experiments to evaluate the adversarial robustness of model checkpoints, we can use the following targets in the Makefile.
```bash
# Launching TextFooler attack
make textfooler_parallel

# Launching A2T attack
make a2t_parallel
```

These commands will search for the model checkpoints presented under "SEARCH_ROOT" (see Makefile), and run the attacks in parallel if multiple GPUs exist on the compute instance. In case there is only one GPU, we can set ``GPUS ?= 0`` in the Makefile, and multiple experiments will run one by one.

### Soft Link
In ``TextFooler`` folder, we assume the following soft link exist so that TextFooler code can import needed package from ``nlp_training`` folder.
```bash
nlp_training@ -> ../nlp_training
```

### Required data for running TextFooler attack.
To run the TextFooler attack, we will need the following data (used by the TextFooler attack).
```bash
tree data_files/TextFooler/
data_files/TextFooler/
├── USE
│   ├── c9fe785512ca4a1b179831acb18a0c6bfba603dd
│   │   ├── saved_model.pb
│   │   └── variables
│   │       ├── variables.data-00000-of-00001
│   │       └── variables.index
│   └── c9fe785512ca4a1b179831acb18a0c6bfba603dd.descriptor.txt
├── embeddings
│   └── counter-fitted-vectors.txt
└── vocab_cosine_sim
    └── ag_cosine_sim_ag.npy

5 directories, 6 files
```
How to get the needed data:
  - ``counter-fitting word embeddings``: [copy_of_link_from_TextFooler_repo](https://drive.google.com/open?id=1bayGomljWb6HeYDMTDKXrh0HackKtSlx)
  - ``ag_cosine_sim_ag.npy``: This file contains similarity matrix that occupies 33GB disk space. If this is not presented, the code will first calculate this matrix based on the counter-fitting word embeddings and saves to this (Note that this process might require a lot CPU RAM due to how the calculation is implemented in the original TextFooler repo).
  - ``USE``
  - We can also refer to the [README](TextFooler/README.md) file of TextFooler repo on how to get these data.

## Analyzing the Results
``results_analysis`` folder contains a complete set of utilities for aggregating and analyzing experimental results. To get the experiment results, one can run
```bash
cd results_analysis
python test_aggregator.py
```
This will create `....aggregated_results.csv` with all experiment data. Note that we might need to redefine the variable "data_path" in the main function of test_aggregator.py in case the experiment results are not stored in the default location.


## Troubleshooting Notes
### Getting the Datasets
We use HuggingFace datasets for getting the dataset for text classification tasks, and launching the experiments should automatically trigger the datasets download if they are not already present in the compute node. In rare cases, e.g., launching many experiments in parallel in a compute instance, it might trigger a rate limit for accessing data from Hugging Face servers. A simple solution is to wait for a while, and the code will automatically retry to download the required dataset.

### Saving checkpoints can occupy disk space.
When launching multiple experiments for a bit larger model (7B parameters), disk space can quickly be occupied (14GB * [number_of_seeds] * [number_of_datasets]). And if disk space is full in the compute instance, it might hang the experiments.

