# Sharpness-Aware Minimization Can Hallucinate Minimizers

Anonymous code repository: [https://anonymous.4open.science/r/SAM-can-hallucinate-minimizers-4B82/](https://anonymous.4open.science/r/SAM-can-hallucinate-minimizers-4B82/)

## Requirements

- Python 3.8+
- [PyTorch](https://pytorch.org/)  
- torchvision  
- numpy  
- matplotlib  
- sympy


## Example 1: 2D synthetic function (Figure 1)

#### SAM Objective vs. SAM Gradient Field
<p align="center">
  <img src="sam_contour.gif" width="46.6%">
  <img src="sam_grad_fxplus.gif" width="43.4%">
</p>

[Example1.ipynb](Example1.ipynb) reproduces the experiment shown in **Figure 1**, described in **Section 1** and detailed in **Appendix D**. It visualizes the SAM objective and the gradient field of the 2D function $f(x, y)$.  

The results above display both the SAM objective and the gradient field for perturbation radii $\rho = 0, 0.05, \ldots, 3.55$.  


---

## Example 2: MNIST + 2-layer neural network (Figure 5)

#### SAM-only vs. Switching Strategy
<p align="center">
  <img src="combined_curve.gif" width="45%">
  <img src="combined_curve_w.gif" width="45%">
</p>

[Example2.ipynb](Example2.ipynb) reproduces the experiment shown in **Figure 5**, described in **Section 4** and detailed in **Appendix C**. It compares SAM-only and the switching strategy on MNIST using a 2-layer neural network trained with full-batch gradients.  

The results above summarize **80 runs**, reporting the training loss and test accuracy for perturbation radii $\rho = 1.0, 1.1, \ldots, 2.0$.
