import os
import requests

# API configuration
url = "https://api.hyperbolic.xyz/v1/chat/completions"
headers = {
    "Content-Type": "application/json",
    "Authorization": "Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJqb3NoZmNvb3BlckB2dC5lZHUiLCJpYXQiOjE3MzgxNzA0Mzh9.nL7suN5ahNp6X5hY2g_LtbDX4ZprgnXWQPMUPbSAwxc"
}

def prompt_model(prompt) -> str:
    data = {
        "messages": [
            {
                "role": "system",
                "content": "You are a helpful assistant."
            },
            {
                "role": "user",
                "content": prompt
            }
        ],
        "model": "deepseek-ai/DeepSeek-V3",
        "max_tokens": 1024,
        "temperature": 1,
        "top_p": 0.9
    }
    
    response = requests.post(url, headers=headers, json=data)
    return response.json()['choices'][0]['message']['content']

MODEL_NAME = "deepseek"
ai_written_text_directory = f'ghostbuster-data/essay/{MODEL_NAME}'
prompt_text_directory = 'ghostbuster-data/essay/prompts'

# Create output directory if it doesn't exist
if not os.path.isdir(ai_written_text_directory):
    os.mkdir(ai_written_text_directory)

# Process each prompt file
for index, filename in enumerate(os.listdir(prompt_text_directory)):
    print(f"Processing filename: {filename}")
    
    prompt_text_file = os.path.join(prompt_text_directory, filename)
    
    if not os.path.isfile(prompt_text_file):
        continue
    
    # Read prompt from file
    with open(prompt_text_file, 'r') as file:
        prompt = file.read()
    
    # Get AI response
    try:
        ai_generated_text = prompt_model(prompt)
        
        # Save response to file
        ai_generated_text_file = os.path.join(ai_written_text_directory, filename)
        with open(ai_generated_text_file, "w") as text_file:
            text_file.write(ai_generated_text)
            
        print(f"Successfully processed {filename}")
        
    except Exception as e:
        print(f"Error processing {filename}: {str(e)}")