#!/bin/bash

CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 deepspeed --master_port 11451 llava/train/train_mem.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path /home/Clawmachine/Lavit/language_model \
    --version plain \
    --data_path /home/Clawmachine/Dataset/LLaVA/LLaVA-Pretrain/blip_laion_cc_sbu_558k.json \
    --image_folder /home/Clawmachine/Dataset/LLaVA/LLaVA-Pretrain/images \
    --vision_tower /home/Clawmachine/LaVIT-7B-v2 \
    --mm_projector_type mlp2x_gelu \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --output_dir ./checkpoints/clawmachine-7b-continuv-pretrain \
    --num_train_epochs 1 \
    --per_device_train_batch_size 32 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 24000 \
    --save_total_limit 1 \
    --learning_rate 1e-3 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True 
