# Equivalent Action SEquences for Exploration (EASEE)


## Intallation

Requires Python 3.8.
All dependencies can be installed by running:
```
pip install -r requirements.txt
```


## Learning-free Exploration

The notebook `learning_free_exploration.ipynb` provides the code for experiments regarding the number of unique visited states.

![plot](images/graph_rotation_states_equality.png)


## DoorKey Training

To train and plot rewards over training run the following. Modify the `--num-seeds` argument to the desired number of runs for each method and `--num-threads` to the number of cpu cores on your machine.

```
python train_tabular.py --num-seeds 15 --num-threads 30 --explore-methods EASEE classic
```

Run `python train_tabular.py -h` for a list of other parameters that can be easily modified. The rewards over training are saved in the *logs* directory. A plot of them is automatically saved to the *images* directory. The plot below is produced by the code above.

![plot](images/doorkey.png)
