# How Patterns Dictate Learnability in Sequential Data

## Prerequisites

Make sure you have the following installed:

- PyTorch 
- Python3
- Numpy
- pandas 
- matplotlib
- json
- tqdm
- yaml
- pathlib
- datetime
- seaborn
- sklearn

## ⚠️ Initial Setup

Before running any script, make sure to **modify the file paths**.  
At the top of each Python script, insert the **absolute path** to the root project directory.

---

## Estimation of the learning curve : Experiment 1

Modify the config file: adjust the `p` parameter at **line 19** to modify the autoregressive order.

```
Data_Pattern_Learnability/configs/ar_sequence_config.yaml
```

Run the experiment:

```
Data_Pattern_Learnability/experiments/experiment_1.py
```
## Display results of Experiment 1

Open the following notebook:

```
Data_Pattern_Learnability/experiments/notebooks/nb_experiment_1.ipynb
```
## Ising Spins Sequences: Experiment 2

Run the experiment:

```
Data_Pattern_Learnability/experiments/experiment_2.py
```

You can adjust the `block_size` parameter at **line 14** to modify the data segmentation.


## Display results of Experiment 2

Open the following notebook:

```
Data_Pattern_Learnability/experiments/notebooks/nb_experiment_2.ipynb
```
