#!/bin/bash

## This is test over WMT 2014 dataset

## translate
python3 translate.py -model model_transformer/averaged-10-epoch.pt \
      -src wmt_ende_sp/test2014.src.en.tok.txt \
      -output pred.txt \
      -replace_unk \
      -verbose \
      -report_bleu \
      -report_rouge \
      -report_time

## evaluate BLEU over tokenized output
perl tools/multi-bleu.perl wmt_ende_sp/test2014.ref.de.tok.txt < pred.txt

## detokenize
spm_decode --model=wmt_ende_sp/wmtende.model --input_format=piece < pred.txt > pred.detok.txt

## evaluate BLEU over detokenized output
perl tools/multi-bleu-detok.perl wmt_ende_sp/test2014.ref.de.txt < pred.detok.txt