#!/bin/bash

## This is test over WMT 2017 dataset

## translate
python3 translate.py -model model_transformer/averaged-10-epoch.pt \
      -src wmt_ende_sp/test.en
      -output pred.txt \
      -replace_unk \
      -verbose \
      -report_bleu \
      -report_rouge \
      -report_time

## evaluate BLEU over tokenized output
perl tools/multi-bleu.perl wmt_ende_sp/test.de < pred.txt

## detokenize
spm_decode --model=wmt_ende_sp/wmtende.model --input_format=piece < pred.txt > pred.detok.txt

## evaluate BLEU over detokenized output
perl tools/multi-bleu-detok.perl wmt_ende_sp/newstest2017-ende-ref.de < pred.detok.txt

cp pred.txt pred____.txt
cp pred.detok.txt pred____.detok.txt