"""
Run multiple experiments on a single machine.
"""
import subprocess

ALGOS = ["a2c", "ppo", "sac", "td3"]
ENVS = ["HalfCheetahBulletEnv-v0", "AntBulletEnv-v0", "HopperBulletEnv-v0", "Walker2DBulletEnv-v0"]
N_SEEDS = 10
EVAL_FREQ = 10000
N_EVAL_EPISODES = 10

for algo in ALGOS:
    for env_id in ENVS:
        for _ in range(N_SEEDS):
            args = [
                "--algo",
                algo,
                "--env",
                env_id,
                "--eval-episodes",
                N_EVAL_EPISODES,
                "--eval-freq",
                EVAL_FREQ,
            ]
            args = list(map(str, args))

            ok = subprocess.call(["python", "train.py"] + args)
