import os

from setuptools import find_packages, setup

with open(os.path.join("gsde_custom", "version.txt"), "r") as file_handler:
    __version__ = file_handler.read().strip()


setup(
    name="gsde_custom",
    packages=[package for package in find_packages() if package.startswith("gsde_custom")],
    package_data={"gsde_custom": ["py.typed", "version.txt"]},
    install_requires=[
        # Master version of SB3
        "stable_baselines3[tests,docs]>=1.1.0a11",
    ],
    description="Code for reproducing gSDE paper.",
    author="",
    url="",
    author_email="",
    keywords="reinforcement-learning-algorithms reinforcement-learning machine-learning "
    "gym openai stable baselines toolbox python data-science",
    license="MIT",
    long_description="",
    long_description_content_type="text/markdown",
    version=__version__,
)

# python setup.py sdist
# python setup.py bdist_wheel
# twine upload --repository-url https://test.pypi.org/legacy/ dist/*
# twine upload dist/*
