"""
Run multiple experiments on a single machine.
"""
import subprocess

import numpy as np

ALGOS = ["custom_sac"]
ENVS = ["CAPS-StateEnv-v0"]
N_SEEDS = 10
EVAL_FREQ = 5000
N_EVAL_EPISODES = 10
SAMPLE_FREQS = [1, 2, 4, 8, 16, 32, 64, 150]
np.random.seed(42)
SEEDS = np.random.randint(2 ** 20, size=(N_SEEDS,))
SCALING_NOISE = [False, True]
std_init = 0.2

for algo in ALGOS:
    for env_id in ENVS:
        for noise_sample_freq in SAMPLE_FREQS:
            for scaling_noise in SCALING_NOISE:
                log_folder = f"logs/gsde_state/noise_sample_freq_{noise_sample_freq}_inde"
                if scaling_noise:
                    log_folder += "_scaling"
                for seed in SEEDS:
                    args = [
                        "--algo",
                        algo,
                        "--env",
                        env_id,
                        "--hyperparams",
                        f"noise_sample_freq:{noise_sample_freq}",
                        "use_sde:False",
                        f"policy_kwargs:dict(std={std_init}, net_arch=[64, 64],"
                        f"state_independent=True, scaling_noise={scaling_noise})",
                        "--eval-episodes",
                        N_EVAL_EPISODES,
                        "--eval-freq",
                        EVAL_FREQ,
                        "-f",
                        log_folder,
                        "--seed",
                        seed,
                        "--log-interval",
                        50,
                        "--num-threads",
                        1,
                    ]
                    args = list(map(str, args))

                    ok = subprocess.call(["python", "train.py"] + args)
