**conda**

We recommend using conda to quickly setup the environment. Please use the following commands.
```bash
conda env create -f environment.yaml
conda activate fedlearn
```

### Train
Federated Learning

Please using following commands to train a model with federated learning strategy.
- **--weighting** specifies aggregation strategy: [propto (default), exp]. **--temperature** specifies the hyperparamter used in Exp-a. **--batch** specifies the batch size. **--E** specifies the number of local epochs. **--iters** specifies the number of global communication rounds. **--name** specify experiment name. 

```bash
cd federated

python federated/fed_train.py --weighting exp --temperature 0.2 --batch 128 --E 2 --iters 200 --name exp_alpha_aggregation --log
python federated/fed_train.py --weighting propto --batch 128 --E 2 --iters 200 --name proportional_aggregation --log