from onlinedatasets.datasets import DataSetUnsupervised
from CMAP_regression_test import get_autoencoded_CMAP_datasets

def get_dataset_CMAP(dataset_name, return_dataframe = False):
	CMAP_datasets_processed = get_autoencoded_CMAP_datasets()
	if dataset_name == "VCAP":
		train_dataset =  CMAP_datasets_processed[0]
	elif dataset_name == "HA1E":
		train_dataset =  CMAP_datasets_processed[1]
	elif dataset_name == "MCF7":
		train_dataset = CMAP_datasets_processed[2]
	elif dataset_name == "A375":
		train_dataset =  CMAP_datasets_processed[3]
	else:
		raise ValueError("CMAP dataset name {} not recognized.".format(dataset_name))	
	if return_dataframe:
		train_dataset.set_return_dataframe(return_dataframe)

	unsupervised_dataset = DataSetUnsupervised(train_dataset.dataset.values)
	return train_dataset, unsupervised_dataset