import IPython
import subprocess
import os
algorithms = ["meanopt"]#, "coreset", "softuncertain", "topuncertain"]
#algorithms = ["coreset", "softuncertain", "topuncertain"]

cycles = [100]

batch_sizes = [16]#, 32, 64, 128, 256, 512]

features = ["achilles"]#, "string"]#, "ccle" ]

datasets = ["schmidt_2021_ifng"]#, "schmidt_2021_il2", "zhuang_2019_nk", "sanchez_2021_tau", "zhu_2021_sarscov2"]

execution_filenames_text = ""

num_experiments = 5
for cycle in cycles:
    for batch_size in batch_sizes:
        for feature in features:
            for dataset in datasets:
                for algorithm in algorithms:
                    for i in range(1, num_experiments+1):
                        cache_directory = "./genedisco_{}_cache_{}_{}_{}".format(algorithm, cycle, batch_size, i)
                        output_directory = "./genedisco_{}_output_{}_{}_{}".format(algorithm, cycle, batch_size, i)

                        execution_filename = "genedisco_{}_{}_{}_{}.sh".format(algorithm, cycle, batch_size, i)

                        if not os.path.isdir(cache_directory):
                          try:
                              os.makedirs(cache_directory)
                          except OSError:
                              print ("Creation of the cache directories failed")
                          else:
                              print ("Successfully created the cache directory ")


                        if not os.path.isdir(output_directory):
                          try:
                              os.makedirs(output_directory)
                          except OSError:
                              print ("Creation of the output directories failed")
                          else:
                              print ("Successfully created the output directory ")





                        a = """active_learning_loop  \\
                            --cache_director={} \\
                            --output_directory={} \\
                            --model_name="bayesian_mlp" \\
                            --acquisition_function_name="{}" \\
                            --acquisition_batch_size={} \\
                            --num_active_learning_cycles={} \\
                            --feature_set_name="{}" \\
                                --dataset_name="{}" """.format(cache_directory, output_directory, 
                                    algorithm, batch_size, cycle, feature, dataset)


                        if algorithm == "meanopt":


                            a = """active_learning_loop  \\
                                --cache_director={} \\
                                --output_directory={} \\
                                --model_name="bayesian_mlp" \\
                                --acquisition_function_name="{}" \\
                                --acquisition_function_path="../zero_noise_bandits/genedisco_mean_opt.py"\\
                                --acquisition_batch_size={} \\
                                --num_active_learning_cycles={} \\
                                --feature_set_name="{}" \\
                                    --dataset_name="{}" """.format(cache_directory, output_directory, 
                                        "custom", batch_size, cycle, feature, dataset)








                        # p = subprocess.Popen(a, stdout=subprocess.PIPE, shell=True)
                        # print(p.communicate())

                        f = open("./" + execution_filename, "w")
                        f.write(a)
                        f.close()

                        execution_filenames_text += "env CUBLAS_WORKSPACE_CONFIG=:4096:8 sh " + execution_filename + ";\n"




f = open("genedisco_run_all.sh", "w")

f.write( execution_filenames_text)

# for execution_filename in execution_filenames:
#     line = "env CUBLAS_WORKSPACE_CONFIG=:4096:8 sh {}; \n".format(execution_filename)

#     f.write(line)

f.close()



# IPython.embed()