# to be imported
"""
Models in NAS aim to provide handcraft models from and AutoML models.
"""
from prototype.nas.sane.backbone import *
from prototype.nas.sane.searchspace import *
from prototype.nas.scnas.backbone import *
from prototype.nas.scnas.searchspace import *
from prototype.nas.spnas.searchspace import *
from prototype.utils.register import Registry

from .baseline_models import *
from .gnn_baseline_models import *

MODELS_REGISTRY = Registry()

imported_vars = list(globals().items())

for var_name, var in imported_vars:
    if callable(var):
        MODELS_REGISTRY.register(var_name, var)

def model_entry(config):
    if config['type'] not in globals():
        return MODELS_REGISTRY[config['type']](**config['kwargs'])
    return globals()[config['type']](**config['kwargs'])