# to be imported
"""
Controllers in NAS aim to provide differnet NAS controller.
"""
from .spnas.controller.gnn_cora_controller import GNNController as spnas_cora
from .spnas.controller.gnn_cora_gpu_controller import GNNController as spnas_cora_gpu
from .spnas.controller.gnn_ppi_controller import GNNPPIController as spnas_ppi
from .spnas.controller.gnn_ppi_gpu_controller import GNNPPIController as spnas_gpu_ppi

from .sane.controller.gnn_ppi_controller import GNNPPIController as sane_ppi
from .sane.controller.gnn_ppi_gpu_controller import GNNPPIController as sane_gpu_ppi
from .sane.controller.gnn_cora_controller import GNNController as sane_cora
from .sane.controller.gnn_cora_gpu_controller import GNNController as sane_cora_gpu

from .scnas.controller.gnn_ppi_controller import GNNPPIController as scnas_ppi
from .scnas.controller.gnn_gpu_ppi_controller import GNNPPIController as scnas_gpu_ppi
from .scnas.controller.gnn_cora_controller import GNNController as scnas_cora
from .scnas.controller.gnn_cora_gpu_controller import GNNController as scnas_gpu_cora

from prototype.utils.register import Registry

CONTROLLERS_REGISTRY = Registry()

imported_vars = list(globals().items())

for var_name, var in imported_vars:
    if callable(var):
        CONTROLLERS_REGISTRY.register(var_name, var)

def controller_entry(config):
    if config['type'] not in globals():
        return CONTROLLERS_REGISTRY[config['type']](**config['kwargs'])
    return globals()[config['type']](**config['kwargs'])