# LatentSeal

Fast, secure & high‑capacity **semantic image watermarking** with text‑autoencoded messages.

> **Spin, Seal, Send** — hide full sentences in images, survive heavy JPEG/crop/noise, decode in real time.

---

## Features
* **Content‑aware payload** – 256‑D unit‑norm latent vectors from a lightweight text autoencoder (TAE).
* **Robust embedding** – finetuned watermark model plus a secret invertible rotation (“spin”) boosts security.
* **High capacity** – > 256 bits (full sentences) per image.
* **Confidence score** – flags unreliable extractions with tunable thresholds.
* **Modular code** – separate folders for TAE and watermarking.

---

## Repository layout
```
autoencoder/         # text autoencoder training & inference
watermark_model/     # embed / detect / training scripts for image watermarks
test_splits/         # sample dataset splits for quick experiments
requirements.txt     # Python dependencies
README.md            # you are here
```





---



---

## License
MIT — see `LICENSE`.

---
